﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private AdvancedLevelBL _AdvancedLevelBL = null;

        public AdvancedLevelBL AdvancedLevel
        {
            get
            {
                if (_AdvancedLevelBL == null)
                {
                    _AdvancedLevelBL = new AdvancedLevelBL(this);
                }

                return _AdvancedLevelBL;
            }
        }

        public class AdvancedLevelBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>,Gemini.Core.BL.Interface.IBORestoreByID
        {
            public AdvancedLevelBL(ZSBELearning BL) : base(BL) { }

            public List<BO.AdvancedLevel> Restore()
            {
                return BLP.DAL.AdvancedLevel.Restore();
            }


            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.AdvancedLevel.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public int Count()
            {
                   return BLP.DAL.AdvancedLevel.Count();
            }

            public BO.AdvancedLevel Restore(long? ID)
            {
                BO.AdvancedLevel _AdvancedLevel = null;
                if (ID.HasValue)
                {
                    _AdvancedLevel = BLP.DAL.AdvancedLevel.Restore(ID);
                }
                return _AdvancedLevel;
            }

            public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
            {
                return Restore(ID);
            }

            public BO.AdvancedLevel Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.AdvancedLevel _AdvancedLevel = null;

                if (BO != null)
                {
                    _AdvancedLevel = BLP.DAL.AdvancedLevel.Restore(BO.ID);
                }

                return _AdvancedLevel;
            }

            public BO.AdvancedLevel RestoreByWeight(int Weight)
            {
                BO.AdvancedLevel.Search _search = new BO.AdvancedLevel.Search();
                _search.Weight = Weight;

                return BLP.DAL.AdvancedLevel.RestoreTopOne(_search);
            }

            public BO.AdvancedLevel Restore(int Point, int MaxPoint)
            {
                BO.AdvancedLevel.Search _search = new BO.AdvancedLevel.Search();
                _search.PointPercent = BLP.Utility.PointPercent(Point, MaxPoint);

                return BLP.DAL.AdvancedLevel.RestoreTopOne(_search);
            }

            public BO.AdvancedLevel Change(int Point, int MaxPoint)
            {
                BO.AdvancedLevel.Search _search = new BO.AdvancedLevel.Search();
                _search.ChangePointPercent = BLP.Utility.PointPercent(Point, MaxPoint);

                return BLP.DAL.AdvancedLevel.RestoreTopOne(_search);
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.AdvancedLevel AdvancedLevel)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (AdvancedLevel == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                            if (AdvancedLevel.ID.HasValue)
                            {
                                _methodResult.SetSuccess = BLP.DAL.AdvancedLevel.Update(AdvancedLevel);
                            }
                            else
                            {
                                _methodResult.SetSuccess = BLP.DAL.AdvancedLevel.Create(AdvancedLevel);
                            }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.AdvancedLevel AdvancedLevel)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (AdvancedLevel != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.AdvancedLevel.Remove(AdvancedLevel);
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exeption);
                    }
                }
                return _methodResult;
            }

            public BO.AdvancedLevel New()
            {
                return BLP.DAL.AdvancedLevel.New();
            }

            private CacheBL _CacheBL = null;

            public CacheBL Cache
            {
                get
                {
                    if (_CacheBL == null)
                    {
                        _CacheBL = new CacheBL(this.BLP);
                    }
                    return _CacheBL;
                }
            }

            public class CacheBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                private Dictionary<long, PI.GM.N610.ELearning.BL.BO.Categorization> _cacheDifficultyDictionary = null;

                private Dictionary<long, BO.AdvancedLevel> _cacheDictionary = null;

                protected Dictionary<long, BO.AdvancedLevel> CacheDictionary
                {
                    get
                    {
                        if (_cacheDictionary == null)
                        {
                            _cacheDictionary = new Dictionary<long, BO.AdvancedLevel>();

                            List<BO.AdvancedLevel> _listAdvancedLevel = BLP.AdvancedLevel.Restore();

                            foreach (BO.AdvancedLevel _loopAdvancedLevel in _listAdvancedLevel)
                            {
                                _cacheDictionary.Add(_loopAdvancedLevel.ID.Value, _loopAdvancedLevel);
                            }
                        }

                        return _cacheDictionary;
                    }
                }

                protected Dictionary<long, PI.GM.N610.ELearning.BL.BO.Categorization> CacheDictionaryDictionary
                {
                    get
                    {
                        if (_cacheDifficultyDictionary == null)
                        {
                            _cacheDifficultyDictionary = new Dictionary<long, PI.GM.N610.ELearning.BL.BO.Categorization>();

                            List<PI.GM.N610.ELearning.BL.BO.Categorization> _listDifficulty = BLP.RBL.ELearning.Categorizatoin.Restore(PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty);

                            foreach (PI.GM.N610.ELearning.BL.BO.Categorization _loopDifficulty in _listDifficulty)
                            {
                                _cacheDifficultyDictionary.Add(_loopDifficulty.ID.Value, _loopDifficulty);
                            }
                        }

                        return _cacheDifficultyDictionary;
                    }
                }

                public CacheBL(ZSBELearning BL) : base(BL) { }

                public BO.AdvancedLevel Restore(long? ID)
                {
                    BO.AdvancedLevel _AdvancedLevel = null;
                    if (ID.HasValue)
                    {
                        _AdvancedLevel = CacheDictionary[ID.Value];
                    }
                    return _AdvancedLevel;
                }

                public string RestoreName(long? ID)
                {
                    string _name = string.Empty;

                    BO.AdvancedLevel _AdvancedLevel = Restore(ID);

                    if (_AdvancedLevel != null)
                    {
                        _name = _AdvancedLevel.Name;
                    }

                    return _name;
                }

                public string RestoreDifficultyName(long? ID)
                {
                    string _Abbreviation = string.Empty;

                    BO.AdvancedLevel _AdvancedLevel = Restore(ID);

                    if ((_AdvancedLevel != null) && (_AdvancedLevel.DifficultyEnumID.HasValue))
                    {
                        if (CacheDictionaryDictionary.ContainsKey(_AdvancedLevel.DifficultyEnumID.Value))
                        {
                            _Abbreviation = CacheDictionaryDictionary[_AdvancedLevel.DifficultyEnumID.Value].Value;
                        }
                    }

                    return _Abbreviation;
                }
            }
        }
    }
}